import st7735
import sprite
import sprites
import controller
import time
import random
import sound
import urandom

class patterns:
    
    def __init__(self,display,controller):
        # This is the constructor for the pattern generator        
        self.gamepad = controller # store reference to controller within this object
        self.display = display # store reference to the display within this object
    def draw_random_rectangles(self):
        # draw random filled rectangles on screen
        while (not self.gamepad.bPressed()):
            x1=urandom.randint(0,120)
            y1=urandom.randint(0,150)
            x2=urandom.randint(0,120)
            y2=urandom.randint(0,150)
            w=urandom.randint(1,127-x1)
            h=urandom.randint(1,159-y1)    
            colour=urandom.randint(0,65535)    
            self.display.fillRectangle(x1,y1,w,h,colour)
        self.display.fillRectangle(0,0,127,159,0)
    def draw(self):
        # draw a 16x16 rectangle that bounces around the screen
        # while randomly changing colours
        x = 0
        y = 0
        old_x = 0
        old_y = 0
        width=16
        height=16
        dx = 1
        dy = 1
        background_colour = 0
        self.display.fillRectangle(0,0,128,160,0)
        while (not self.gamepad.bPressed()):
            # if you can get away with just drawing a rectangle around the
            # coloured box then you will have less flicker
            self.display.drawRectangle(x,y,width,height,background_colour)
            #self.display.fillRectangle(x,y,width,height,background_colour)
            old_x = x
            old_y = y
            if ((x+width) == 127) :
                dx = -1
            if (x == 0):
                dx = 1                    
            x = x + dx
            if ((y+height) == 159) :            
                dy = -1
            if (y == 0):
                dy = 1
            y = y + dy            
            self.display.fillRectangle(x,y,width,height,0xff)
            time.sleep_ms(5)

    def drawRandomTiles(self):
        # fill tiles with random colours
        # divide screen up into a set of 16*16 tiles (8 across by 10 down)
        while (not self.gamepad.bPressed()):
            for x in range(0,8):
                for y in range(0,10):
                    self.display.fillRectangle(x*16,y*16,16,16,urandom.randint(0,65535))
                
        
    def drawSpiralRect(self):
        # draw a rectangular spiral using random colours
        self.display.clear()
        xstart=0
        ystart=0
        x=xstart
        y=ystart
        colour=urandom.randint(0,65535)
        xend=self.display.screen_width-1
        yend=self.display.screen_height-1
        while (not self.gamepad.bPressed()):
            while(x < xend):
                self.display.putPixel(x,y,colour)
                x = x + 1
            colour=urandom.randint(0,65535)            
            while(y < yend):
                self.display.putPixel(x,y,colour)
                y = y + 1
            colour=urandom.randint(0,65535)                
            while(x > xstart):
                self.display.putPixel(x,y,colour)
                x = x - 1
            colour=urandom.randint(0,65535)                
            ystart = ystart + 5
            while(y > ystart):
                self.display.putPixel(x,y,colour)
                y = y - 1
            colour=urandom.randint(0,65535)                
            xstart = xstart + 5
            xend=xend-5
            yend=yend-5
            if (xend <= xstart):
                xstart=0
                ystart=0
                xend=self.display.screen_width-1
                yend=self.display.screen_height-1
                x=xstart
                y=ystart
                

           
                
            