import sprite
import sprites
import controller
import time
import random
import sound
import array
import sprite
from colours import *

class invaders:
    def prepare_sprites(self):
        self.invader1_image=array.array('h',
                [BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,
                 BLK,BLK,BLK,BLU,GRN,YEL,GRN,BLU,BLK,BLK,BLK,
                 BLK,BLK,BLK,BRD,BRD,BRD,BRD,BRD,BLK,BLK,BLK,
                 BLK,BLK,BLK,BRD,BRD,BRD,BRD,BRD,BLK,BLK,BLK,
                 BLK,BLK,BRD,WHI,BRD,BRD,BRD,WHI,BRD,BLK,BLK,
                 BLK,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BLK,
                 BLK,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BLK,
                 BLK,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BRD,BLK,
                 BLK,BRD,BRD,BLK,BLK,BLK,BLK,BLK,BRD,BRD,BLK,
                 BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK])
        self.invader1_w=11
        self.invader1_h=10
        self.base_image=array.array('h',
                [BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,
                 BLK,BLK,BLK,BLK,WHI,WHI,WHI,BLK,BLK,BLK,BLK,
                 BLK,BLK,BLK,WHI,WHI,WHI,WHI,WHI,BLK,BLK,BLK,
                 BLK,WHI,WHI,WHI,WHI,WHI,WHI,WHI,WHI,WHI,BLK,
                 BLK,WHI,WHI,WHI,WHI,WHI,WHI,WHI,WHI,WHI,BLK,
                 BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK])
        self.base_w=11
        self.base_h=6
        self.missile_up_image=array.array('h',
                [BLK,BLK,BLK,BLK,BLK,
                 BLK,BLK,BBL,BLK,BLK,
                 BLK,BLK,BBL,BLK,BLK,
                 BLK,BBL,BBL,BBL,BLK,
                 BLK,BBL,BBL,BBL,BLK,
                 BLK,BLK,YEL,BLK,BLK,
                 BLK,BLK,BLK,BLK,BLK])
        self.missile_up_w=5
        self.missile_up_h=7
        self.missile_down_image=array.array('h',
                [BLK,BLK,BLK,BLK,BLK,
                 BLK,BLK,WHI,BLK,BLK,
                 BLK,GRN,GRN,GRN,BLK,
                 BLK,GRN,GRN,GRN,BLK,
                 BLK,BLU,GRN,BLU,BLK,
                 BLK,BLK,GRN,BLK,BLK,
                 BLK,BLK,BLK,BLK,BLK])
        self.missile_down_w=5
        self.missile_down_h=7
        self.explode_image = array.array('h',
                [BLK,BLK,BLK,BLK,BLK,
                 BLK,BLK,YEL,BLK,BLK,
                 BLK,BLK,YEL,GRN,BLK,
                 BLK,YEL,YEL,YEL,BLK,
                 BLK,BLU,YEL,BLU,BLK,
                 BLK,BLK,YEL,BLK,BLK,
                 BLK,BLK,BLK,BLK,BLK])
        self.explode_w=5
        self.explode_h=7
        
    def __init__(self,display,controller,snd):
        # This is the constructor for the brici game.
        # it is called when the brici game object is created.
        # The code that creates this game must pass a reference
        # to the display device and the controller
        self.controller = controller # store reference to controller within this object
        self.display = display # store reference to the display within this object
        self.snd=snd # store reference to sound output object
        random.seed() # initialize the random numeber generator so the game doesn't repeat itself
        display.clear()
        self.prepare_sprites();
        self.Invaders=[sprite.sprite(4,4,self.invader1_w,self.invader1_h,self.invader1_image,display),
                       sprite.sprite(4,4,self.invader1_w,self.invader1_h,self.invader1_image,display),
                       sprite.sprite(4,4,self.invader1_w,self.invader1_h,self.invader1_image,display),
                       sprite.sprite(4,4,self.invader1_w,self.invader1_h,self.invader1_image,display),
                       sprite.sprite(4,4,self.invader1_w,self.invader1_h,self.invader1_image,display)]
        self.Defender=sprite.sprite(0,140,self.base_w,self.base_h,self.base_image,display)
        self.DefenderMissiles=[sprite.sprite(40,100,self.missile_up_w,self.missile_up_h,self.missile_up_image,display),
                      sprite.sprite(40,100,self.missile_up_w,self.missile_up_h,self.missile_up_image,display),
                      sprite.sprite(40,100,self.missile_up_w,self.missile_up_h,self.missile_up_image,display),
                      sprite.sprite(40,100,self.missile_up_w,self.missile_up_h,self.missile_up_image,display),
                      sprite.sprite(40,100,self.missile_up_w,self.missile_up_h,self.missile_up_image,display)]
        self.AttackerMissiles=[sprite.sprite(40,60,self.missile_down_w,self.missile_down_h,self.missile_down_image,display),
                      sprite.sprite(40,60,self.missile_down_w,self.missile_down_h,self.missile_down_image,display),
                      sprite.sprite(40,60,self.missile_down_w,self.missile_down_h,self.missile_down_image,display),
                      sprite.sprite(40,60,self.missile_down_w,self.missile_down_h,self.missile_down_image,display),
                      sprite.sprite(40,60,self.missile_down_w,self.missile_down_h,self.missile_down_image,display)]
        self.explosion = sprite.sprite(0,0,self.explode_w,self.explode_h,self.explode_image,display)
        self.bonk=sound.note(500,50,0)
        self.beep=sound.note(1000,50,0)
    def explode(self,x,y):
        self.explosion.show()
        self.explosion.move(x,y)
        self.snd.tune.append(self.beep)
        time.sleep_ms(20)
        self.explosion.hide()
    def play(self):        
        RemainingDefenders=5
        self.Defender.show()
        count=0
        for m in self.Invaders:
            m.x = count*20
            count=count+1
            m.show()
        for m in self.DefenderMissiles:
            m.hide()
        for m in self.AttackerMissiles:
            m.hide()
        GameOver = 0;
        ActiveAttackerMissiles = 0
        DefenderMissileCounter = 0;
        InvaderCounter = 0;
        XDirectionChange = 0
        YDirectionChange = 0
        LevelComplete = 0;
        x_step = 2;
        y_step = 2;
        DefenderMissilePauseTimer=0
        AttackerMissilePauseTimer=0
        MAX_ATTACKER_MISSILES=len(self.AttackerMissiles)
        MAX_DEFENDER_MISSILES=len(self.DefenderMissiles)
        while(LevelComplete==0):
            if DefenderMissilePauseTimer > 0:
                DefenderMissilePauseTimer=DefenderMissilePauseTimer-1
                
            if AttackerMissilePauseTimer > 0:
                AttackerMissilePauseTimer=AttackerMissilePauseTimer-1            
            time.sleep_ms(20)
            self.display.print(str(RemainingDefenders),110,141,YEL,0)
            self.Defender.show()
            if (self.controller.rightPressed()):
                if (self.Defender.x < 115):
                    self.Defender.move(self.Defender.x+2,self.Defender.y)
            if (self.controller.leftPressed()):
                if (self.Defender.x > 1):
                    self.Defender.move(self.Defender.x-2,self.Defender.y)
            if (self.controller.aPressed()):
                if (DefenderMissilePauseTimer==0):
                    for m in self.DefenderMissiles:
                        # look for an unused (invisible) missile
                        if m.visible==0:
                            m.show()
                            m.move(int(self.Defender.x+self.base_w/2-self.missile_up_w/2),self.Defender.y-self.missile_up_h-1)
                            DefenderMissilePauseTimer = 10
                            break
                        
            # update defender missiles
            for m in self.DefenderMissiles:
                if ( (m.y > 0) and (m.visible==1 ) ):
                    m.move(m.x,m.y-2)
                    for inv in self.Invaders:
                        if inv.isOverlapping(m):
                            # missile meets invader!                            
                            inv.hide()
                            self.explode(inv.x,inv.y)
                else:
                    if (m.visible==1):
                        m.hide()
            # update attacker missiles
            for m in self.AttackerMissiles:
                if (m.y < (self.display.screen_height-20)) and m.visible==1:
                    m.move(m.x,m.y+2)                    
                    # did any attacker missile hit the defender?
                    if (m.y >= self.Defender.y) and (m.x>=self.Defender.x) and (m.x <= self.Defender.x+self.Defender.width) :
                        RemainingDefenders=RemainingDefenders-1
                        if (RemainingDefenders <= 0):
                            self.display.clear()
                            self.display.print("Game over!",10,60,0xffff,0)
                            while(self.controller.aPressed()==0):
                                continue
                            
                            return
                        ActiveAttackerMissiles = ActiveAttackerMissiles - 1
                        self.explode(m.x,m.y)
                        m.hide()
                else:
                    if(m.visible == 1):
                        m.hide()
                        if (ActiveAttackerMissiles > 0):
                            ActiveAttackerMissiles = ActiveAttackerMissiles - 1
            # update invaders
            XDirectionChange = 0
            YDirectionChange = 0
            LevelComplete  = 1
            for inv in self.Invaders:
                if (inv.visible==1):
                    if (ActiveAttackerMissiles < MAX_ATTACKER_MISSILES) and (random.randint(1,5)==2):
                        for m in self.AttackerMissiles:
                            # look for an unused attacker missile
                            if AttackerMissilePauseTimer == 0:
                                if (m.visible==0):
                                    ActiveAttackerMissiles = ActiveAttackerMissiles + 1
                                    m.show()
                                    m.move(int(inv.x+inv.width/2),inv.y+inv.height+1)
                                    AttackerMissilePauseTimer = 10
                                    break
                    LevelComplete = 0 # not over yet as there are still visible invaders
                    inv.move(inv.x+x_step,inv.y+y_step)
                    if inv.x > (self.display.screen_width-inv.width):
                        XDirectionChange = 1
                    if (inv.x <= 1):
                        XDirectionChange = 1
                    if inv.y > (self.display.screen_height - 60):
                        YDirectionChange = 1
                    if inv.y < 3:
                        YDirectionChange = 1
            if (LevelComplete==1):
                self.display.clear()
                self.display.print("You win!",10,60,0xffff,0)
                while(self.controller.aPressed()==0):
                    continue
                
                return
            if XDirectionChange==1:
                x_step = -x_step
            if YDirectionChange==1:
                y_step = -y_step
            
                        
                


